#|____________________________________________________________________
 |
 |  messages3.lsp 
 |  code for INITIAL-PRESENTATIONS and ABOUT-VISTA 
 |  and for funtions
 |  (about-vista) (created-by) (title-cinerama) (simple-logo)
 |  (splash-screen) (copyrighted-by) 
 |  Copyright (c) 2001 by Forrest W. Young
 |  All rights reserved 
 |____________________________________________________________________
 |#






(defun initial-presentations (&optional (series-number 1)) 
  (let ((presentation-number (if *devel-mode* series-number (1+ series-number))))
    (case presentation-number 
      (1 ;(restore-desktop)
         (welcome-developer))
      (2 ;(restore-desktop)	
         (welcome-to-vista-with-registration)
         (send *vista* :show-first-help t)
         (send *vista* :show-welcome nil))
      (t 
         (if (send *vista* :show-first-help)
             (help--))
         (if (send *vista* :show-welcome) 
             (welcome-to-vista))
       (send *workmap* :active-window)
       ))))


#|
 | ABOUT-VISTA
 |#

(defun about-vista (&rest args) (about-vista-with-logo))

(defun about-vista-with-logo (&key (exit nil))
  (title-cinerama)
  (if exit
    (choice-item-dialog
      "Make Your Choice"
       (list "Contact Information"
             "Copyright Information"
             "Poetric Tribute"
             "Acknowledgements"
             "About Forrest Young"
             "About Pedro Valero-Mora"
              "About Gabriel Molina" 
             "Exit Vista")
       (list  '(title-cinerama) '(copyright-cinerama) '(poem-cinerama)
              '(acknowledgements-cinerama) '(fwy-cinerama) '(pedro-cinerama) 
              '(gabi-cinerama) '(vista-exit))
      :location '(100 100) 
      :title "About ViSta")
     (choice-item-dialog
      "Make Your Choice"
       (list "Contact Information"
             "Copyright Information"
             "Poetric Tribute"
             "Acknowledgements"
             "About Forrest Young"
             "About Pedro Valero-Mora"
              "About Gabriel Molina")
       (list  '(title-cinerama) '(copyright-cinerama) '(poem-cinerama)
              '(acknowledgements-cinerama) '(fwy-cinerama) '(pedro-cinerama) 
              '(gabi-cinerama))
      :location '(100 100) 
      :title "About ViSta")))

(setf cinerama-size '(440 380))
(setf cinerama-margin '(40 240 40 30))
(setf *cinerama* nil)



(setf title-text (list
" "
"         ViSta: The Visual Statistics System    "
"            Created by:  Forrest W. Young        "
"          On the Web at www.visualstats.org"

(strcat "      " *copyright-string*)
"       Portions copyrighted by others as shown"
(strcat "      " *version-string*)

"                                                " 
"                    CONTACT US AT                "
"       Forrest Young:  forrest@visualstats.org"
"      Pedro Valero-Mora:  pedro@visualstats.org"
"        Gabriel Molina:  gabi@visualstats.org"
" "
"                      NEWSGROUP"
"                    vista@unc.edu"))



  (defun title-cinerama 
    (&rest args &key (text title-text)
           (size '(400 680))
           (x 25) (y 10) (static nil) (margin '(15 280 15 15)))
   
    (let ((twid (apply #'twiddle :text text :static static 
                        :margin cinerama-margin  :size cinerama-size
                      :x x :y y  args)))
      (when *cinerama* (send *cinerama* :remove))
      (setf *cinerama* twid)
      *cinerama*))
  
(defun about-vista- () (simple-logo :static t))

  ;ABOUT VISTA - COPYRIGHTS
  
(defun copyright-cinerama (&rest args &key (text (copyrights)) (size '(480 480))
                                   (x 25) (y 10) (static nil) (margin '(15 280 15 15)))
    (let ((twid (apply #'twiddle :text text :static static 
                        :margin cinerama-margin  :size cinerama-size
                        :x x :y y   args)))
      (when *cinerama* (send *cinerama* :remove))
      (setf *cinerama* twid)
      *cinerama*))

  ;(defmeth twid :closing-method () 
  ;      (send self :wire-frame nil)
  ;      (send self :disolve :disolve-type (1- (floor (* 3 (uniform-rand 1))))))
  
  
  ;ABOUT VISTA - POEM

  (defun poem-cinerama 
    (&rest args &key (text on-data-analysis) (size '(480 480))
           (x 25) (y 10) (title "insight & seeing truth    -    by forrest w young")
           (static nil) (margin '(15 280 15 15)))
    (let ((twid (apply #'twiddle :text text :static static 
                       :margin cinerama-margin  :size cinerama-size
                       :x x :y y :title title args)))
      (when *cinerama* (send *cinerama* :remove))
      (setf *cinerama* twid)
      *cinerama*))

(defun exit-cinerama 
    (&rest args &key (text on-data-analysis) (size '(480 480))
           (x 25) (y 10) (title "insight & seeing truth    -    by forrest w young")
           (static nil) (margin '(15 280 15 15)))
    (let ((twid (apply #'twiddle :text text :static static 
                       :margin cinerama-margin  :size cinerama-size
                       :x x :y y :title title args)))
      (when *cinerama* (vista-exit))
      (setf *cinerama* twid)
      *cinerama*))
  

;ABOUT VISTA - ACKNOWLEDGEMENTS

(defun acknowledgements-cinerama (&key (draw-color 'yellow) (back-color 'black))
  (let* (;(text (select (get-text-messages 16) (combine 0 (iseq 2 15))))
         (text (select (get-text-messages 16) (iseq 2 15)))
         (whole (add-header-footer 
                   text
                   nil        
                   " Next: Left-Click   Back: Right-Click   Exit: Ctrl-Click"))
         (twid (twiddle :text whole
                          :show-time 20 :x 25 :y 10
                          :pause 0 :no-repeat nil :wire-frame nil :speed .5
                          :margin cinerama-margin  :size cinerama-size
                          :draw-color draw-color :back-color back-color ))
         )
    (defmeth twid :do-click (x y m1 m2)
      (cond 
        ((and (not m1) (not m2)) 
         (send twid :next-slide))                         ;left button next
        (m2 (send self :msg-number 
                  (max 0 (- (send self :msg-number) 2)))
            (send twid :next-slide))                      ;right button back
        (m1 (send twid :shut-down))                        ;cntl-button en
        (t  (send twid :next-slide))))
    (defmeth twid :closing-method () 
      (send self :wire-frame nil)
      (send self :disolve :disolve-type 
            (1- (floor (* 3 (uniform-rand 1))))))
    (defmeth twid :do-key (a m1 m2) ;any key end
      (send twid :do-click 1 1 nil t))
    (defmeth twid :do-time ()
      (send twid :next-slide ))
    (when *cinerama* (send *cinerama* :remove))
    (setf *cinerama* twid)
    *cinerama*))

(defun fwy-cinerama ()
  (author-cinerama (fwy-bio-for-logo) " Forrest W. Young"))

(defun pedro-cinerama ()
  (author-cinerama (pedro-bio-for-logo) " Pedro Valero-Mora"))

(defun gabi-cinerama ()
  (author-cinerama (gabi-bio-for-logo) " J. Gabriel Molina"))

(defun exit-cinerama ()
  (vista-exit))
  
(defun author-cinerama (text name &key (draw-color 'yellow) (back-color 'black))
    (let* ((whole (add-header-footer 
                   text
                   name         
                   " Next: Left-Click   Back: Right-Click   Exit: Ctrl-Click"))
           (twid (twiddle :text whole
                          :show-time 20 :x 25 :y 10
                          :pause 0 :no-repeat nil :wire-frame nil :speed .5
                          :margin cinerama-margin  :size cinerama-size
                          :draw-color draw-color :back-color back-color ))
           )

      (defmeth twid :do-click (x y m1 m2)
        (cond 
          ((and (not m1) (not m2)) 
           (send twid :next-slide))                         ;left button next
          (m2 (send self :msg-number 
                    (max 0 (- (send self :msg-number) 2)))
              (send twid :next-slide))                      ;right button back
          (m1 (send twid :shut-down))                        ;cntl-button en
          (t  (send twid :next-slide))))
        
      (defmeth twid :closing-method () 
        (send self :wire-frame nil)
        (send self :disolve :disolve-type 
              (1- (floor (* 3 (uniform-rand 1))))))
      (defmeth twid :do-key (a m1 m2) ;any key end
        (send twid :do-click 1 1 nil t))

      (defmeth twid :do-time ()
        (send twid :next-slide ))

      (when *cinerama* (send *cinerama* :remove))
      (setf *cinerama* twid)
      *cinerama*))


(defun fwy-bio-for-logo ()
(make-logo-list-of-string-lists (list 

(string-to-string-list "Forrest W. Young, Professor Emeritus at the University of North Carolina at Chapel Hill, received his PhD in Psychometrics from the University of Southern California in 1967. He has been on the faculty of UNC-CH ever since.")

(string-to-string-list "Prof. Young's teaching interests focus on \"Seeing what your data seem to say\". This visually intuitive approach to statistics helps to clarify the meaning of data. His courses, ranging from his introductory undergraduate course on Psychological Statistics, to his advanced graduate courses on Data Analysis, Visualization and Exploration, reflect this focus.")

(string-to-string-list 
"To make the process of understanding data visually intuitive, the burden is moved from the person to the computer. You don't need to make an intensive effort to understand your data: Rather, your computer makes intensive calculations so that the data can be shown to you in a visually comprehensible way.")

(string-to-string-list 
"This approach to the role of computers is based on the intelligence augmentation (IA) philosophy of Computer Science: Your computer is a device which should augment your intelligence. It is also based on a Cognitive Science theory for the construction of an environment for data analysis.")

(string-to-string-list 
"Prof Young and his students, over the course of a 10-year research and development project, have created ViSta, a visual statistics system instantiating Prof. Young's theories concerning visual environments for statistical analysis.")

(string-to-string-list 
"ViSta is a freely available system that is being used for teaching introductory and multivariate statistics, for data analysis by statistically inexperienced researchers as well as by those who are more advanced, and for advanced research and development in graphical and computational statistics.")

(string-to-string-list 
"ViSta is based not only on Prof. Young's theory-based approach to data analysis, but also on his 30-year career in computational and graphical statistics.")

(string-to-string-list
"Prof. Young's early research interests focused on Multidimensional and Nonlinear Multivariate Data Analysis (for which he was elected the President of the Psychometric Society, and received the American Market Research Association's O'Dell award, both in 1981). Via these research interests, Prof. Young became involved in software development early in his career.")

(string-to-string-list  
"Prof. Young has served as a professional consultant on statistical system interface design with SAS Institute, Statistical Sciences (the S-Plus system), and BMDP Inc. He has written or designed data analysis modules for the SAS, SPSS and IMSL systems. He is a member of the American Statistical Association's sections on Computational and Graphical Statistics."))))



(defun gabi-bio-for-logo ()
(make-logo-list-of-string-lists (list 

(string-to-string-list "J. Gabriel Molina is Assistant Professor in the Department of Research Methods at the University of Valencia (Spain). He received his PhD in Psychology from the University of Valencia in 1997 with a dissertation on computerized item banking for the development of adaptive tests. He is also member of the Traffic Research Institute at the University of Valencia.")

(string-to-string-list "Prof. Molina research interests focus on Data Processing and Analysis, Computerized Tests, and Traffic Psychology. In all these fields, he has worked in the development of computer methods oriented to enhance data management and analysis from a psychological basis, that is, computer tools that are useful for psychologists and social researchers and, at the same time, that take into account the developments in Psychology related to how to build more efficient programs for the final users."))))

(defun pedro-bio-for-logo ()
(make-logo-list-of-string-lists (list 

(string-to-string-list "Pedro M. Valero-Mora, Profesor Titular at the Universitat de Valencia (Spain), received his PhD in Psychology from this same university in 1996. He works in the department of Methodology of the Behavioural Sciences since 1990, teaching courses related to Introductory and Multivariate Statistics, Data Processing and Computers.")

(string-to-string-list "Pedro Valeros research interests have focused on Statistics and on Human Computer Interaction, investigating how to design computer interfaces that are more useful, friendly and rewarding for users. The mixing of these interests with his teaching has drawn his attention to the development of innovative computer interfaces for statistical analysis and visualization.")

(string-to-string-list "His programming efforts have been guided by the principles of direct manipulation, instant output and graphical visualization.")

(string-to-string-list "The assumption is that the users should be able to manipulate directly visual representations of statistical techniques that respond immediately to their actions so they can understand more easily the consequences of the different choices under their control. As a result, the users can feel more confidence experimenting with the system so they can obtain a deeper understanding of the statistical concepts underlying the software.")

(string-to-string-list "The development of this type of software has been possible by the Lisp-Stat language and the ViSta system. These tools have made possible programming methods for Missing Data Imputation, visually controlled transformations and log-linear analysis, as well as, jointly with Rubn Ledesma from the University of Mar del Plata, an adaptation of a homogeneity analysis module.")

(string-to-string-list "Other contributions to ViSta have consisted mainly on bug corrections, testing, documentation writing and translating, etc. These contributions have found its way into papers in academic journals focused on graphics and computers in statistics as well as in Human-Computer Interaction debate forums."))))



  (defun cinerama-title ()
    (select (get-text-messages 2) 0))

  ;ABOUT VISTA - SUMMARY
  
  (defun about-summary ()
    (let* ((text (list " "
                      "This topic begins with information on:"
                      "> How to contact us;"
                      "> Copyrights."
                      "  "
                      "These initial topics are followed by"
                      "Prof. Young's:"
                      "> Poetic tribute to data analysis;"
                      "> Personal acknowledgements to those who" 
                      "  have contributed to ViSta;"
                      "> brief autobiographical statement."))
           (twid (twiddle :text text :static nil
                          :margin cinerama-margin  :size cinerama-size
                          :x 75 :y 15))
           )
      (when *cinerama* (send *cinerama* :remove))
      (setf *cinerama* twid)
      *cinerama*))
  
;ABOUT VISTA - CONTACTING US

  (setf vvssfwy 
        (list
"     ViSta: The Visual Statistics System"
"         Created by: Forrest W Young"
"             www.visualstats.org" 
 " "   " "   " " " "  " "   " "   " "))

(defun hyper-title-text ()
(setf hyper-title-text 
(make-logo-list-of-string-lists 
(list
(list
"     ViSta: The Visual Statistics System"
"         Created by: Forrest W Young"
"             www.visualstats.org" 
 " "   " "   " " " "  " "   " "   " "
(strcat " " *copyright-string*)
"   Portions copyrighted by others as shown"
(strcat "   " *version-string*))

(list
"     ViSta: The Visual Statistics System"
"         Created by: Forrest W Young"
"             www.visualstats.org" 
 " "   " "   " " " "  " "   " "   " "
"      Forrest Young : forrest@visualstats.org"
"  Pedro Valero-Mora : pedro@visualstats.org"
"      Gabiel Molina : gabi@visualstats.org")
" "

(list
"     ViSta: The Visual Statistics System"
"         Created by: Forrest W Young"
"             www.visualstats.org" 
 " "   " "   " " " "  " "   " "   " "
"  ViSta Users Group : vista@visualstats.org"
"  Bugs and Problems : bugs@visualstats.org")

(list
"     ViSta: The Visual Statistics System"
"         Created by: Forrest W Young"
"             www.visualstats.org" 
 " "   " "   " " " "  " "   " "   " "
"  Documentors Group : doco@visualstats.org"
"   Developers Group : devel@visualstats.org"
"  Translators Group : trans@visualstats.org")))))

  
(defun contact-us-movie 
    (&rest args &key (text created-by)
           (size '(340 210)) (hide-logo nil) (delay 3) (show-time 3)
           (x 10) (y 10) (static nil) (margin '(25 65 25 65)))
    (let ((twid (apply #'twiddle :text text :x x :y y :size size :hide-logo hide-logo
                       :static static :margin margin args)))
      twid))


  (defun hyper-title
    (&rest args &key (text (hyper-title-text))
           (size '(340 210)) (hide-logo nil)
           (x 10) (y 10) (static nil) (margin '(25 65 25 65)))
    (let ((twid (apply #'twiddle :text text :x x :y y :size size :hide-logo hide-logo
                       :static static :margin margin args)))
      
      (defmeth twid :do-click (x y m1 m2)
      (cond 
        ((and (not m1) (not m2)) 
         (send twid :next-slide))                         ;left button next
        (m2 (send self :msg-number 
                  (max 0 (- (send self :msg-number) 2)))
            (send twid :next-slide))                      ;right button back
        (m1 (send twid :shut-down))                        ;cntl-button en
        (t  (send twid :next-slide))))
    (defmeth twid :closing-method () 
      (send self :wire-frame nil)
      (send self :disolve :disolve-type 
            (1- (floor (* 3 (uniform-rand 1))))))
    (defmeth twid :do-key (a m1 m2) ;any key end
      (send twid :do-click 1 1 nil t))
    (defmeth twid :do-time ()
      (send twid :next-slide ))
    (when *cinerama* (send *cinerama* :remove))
    (setf *cinerama* twid)
    *cinerama*))


;ABOUT VISTA - CONTACTING US

  

(setf splash-screen (list
"         ViSta: The Visual Statistics System"
"             Created by: Forrest W Young"
" "
(strcat "     " *copyright-string*)
(strcat "    " *version-string*)
" " 
"                 www.visualstats.org" 
"               forrest@visualstats.org"
"                vista@visualstats.org"))

  (defun simple-logo
    (&rest args &key (text splash-screen)
           (size '(400 150)) (hide-logo nil) (show t)
           (x 10) (y 10) (static nil) (margin '(25 25 25 25)))
    (let ((twid (apply #'twiddle :text text :x x :y y :size size :hide-logo hide-logo
                       :static static :margin margin :show show args)))
      twid))

(defun copyrighted-by (&rest args &key (hide-logo nil) (size '(350 150)) (x 10) (y 10) (static nil) (margin '(25 70 25 25)))
  (let* ((str-lst 
         (list 
          (list "XLISP-PLUS version 3.04" "Portions Copyright (c) 1988, by David Betz." "Modified by Thomas Almy and others.")
          (list  "XLISP-STAT Release 3.52.13 (Beta)." "Copyright (c) 1989-1999, by Luke Tierney.")
          (make-vista-copyright)))
        (twid (apply #'twiddle :text str-lst  
                     :x x :y y
                     :show-time 3 :pause 1  :delay 0
                     :size size :hide-logo hide-logo
                     :static static :margin margin args)))
    
    (defmeth twid :do-click (x y m1 m2)
      (cond 
        ((and (not m1) (not m2)) 
         (send twid :next-slide))                         ;left button next
        (m2 (send self :msg-number 
                  (max 0 (- (send self :msg-number) 2)))
            (send twid :next-slide))                      ;right button back
        (m1 (send twid :shut-down))                        ;cntl-button en
        (t  (send twid :next-slide))))
    (defmeth twid :closing-method () 
      (send self :wire-frame nil)
      (send self :disolve :disolve-type 
            (1- (floor (* 3 (uniform-rand 1))))))
    (defmeth twid :do-key (a m1 m2) ;any key end
      (send twid :do-click 1 1 nil t))
    (send twid :timer-on 3)
    (setf *cinerama* twid)
    twid))

(setf splash-text (list
"   ViSta:  The Visual Statistics System"
"        http://www.visualstats.org"
 " "   " "   " " " "  " "   " "   " "
(strcat " " *copyright-string*)
(strcat " " *version-string*)
))

(defun splash-screen
    (&rest args &key (text splash-text) (show t)
           (size '(320 170)) (hide-logo nil) ;(container nil)
           (x  10) (y 2) (static t) (margin '(20 40 20 42)))
    (let ((twid (apply #'twiddle :text text :x x :y y :size size :hide-logo hide-logo
                       :static static :margin margin :show show 
                       :location (floor (/ (- (screen-size) size) 2))
                       args)))
      twid))

(setf xls-creators 
      (list  
"     XLISP-STAT Release 3.52.13 (Beta)."
" Copyright (c) 1989-1999, by Luke Tierney."
 " " 
"         XLISP-PLUS version 3.04"
"Portions Copyright (c) 1988, by David Betz."
"    Modified by Thomas Almy and others." 
             ))

(defun xls-splash-screen
    (&rest args &key (text xls-creators)
           (size '(340 180)) (hide-logo nil) 
           (x 10) (y 5) (static t) (margin '(25 50 25 50)))
    (let ((twid (apply #'twiddle :text text :x x :y y :size size :hide-logo hide-logo
                       :static static :margin margin args)))
      ;(send twid :interpolate)
      twid))




;the following code is headed in the direction of being a general way of
;displaying text from a file in the logo screen, with paragraphs
;corresponding with displays on the scrren.

;it is currently kludged together to work for this one set of text

(defun string-to-string-list (string &optional (line-length 50))
"Args: STRING &OPTIONAL (LINE-LENGTH 50)
Converts a string to a list of strings. Each string in the list is terminated by the first space that appears after LINE-LENGTH characters. Used by twiddle to convert regular text into the text-list needed for it to display."
  (let* ((numchar (length string))
         (pretty-string)
         (start 0)
         (finish)
         (split)
         )
    (setf string (strcat " " string))
    (loop
     (setf split  (position #\newline string :start start))
     (setf finish (position #\        string :start (min numchar (+ start line-length))))
     (when (and split (> split finish)) (setf split nil))
     (setf substring (if split "  " (subseq string start finish)))
     (setf pretty-string (append pretty-string (list substring)))
     (unless finish (return))
     (setf start (position #\         string :start (+ start line-length))))
    pretty-string))

(defun read-text-file ()
  (with-open-file 
    (f (strcat *help-dir-name* "fwy2.hlp"))
   (let ((text-line)
         (text-list)
         )
     (loop
      (setf text-line (read-line f nil nil))
      (unless text-line (return))
      (setf text-list 
            (append text-list (list (list text-line)))))
     text-list)))


(defun make-logo-list-of-string-lists (intext-list)
"Args: TEXT-LIST
Modify message structure so that all text messages have the same number of lines (a requirement for logo-proto2) by padding with blank lines at the end."
  (let* ((text-list)
         (temp-list) 
         (num-msgs (length intext-list))
         (pad-num (max (mapcar #'length intext-list)))
         )
    (mapcar #'(lambda (msg-num)
                (setf temp-list (select intext-list msg-num))
                (if pad-num 
                    (setf temp-list (pad-text-list temp-list pad-num)))
                (setf text-list 
                      (append text-list 
                              (list temp-list))))
            (iseq num-msgs))
    text-list))

(defun add-header-footer (list-of-string-lists &optional (header "  ") (footer "  "))
     (mapcar #'(lambda (string-list)
               (if header
                   (combine header " "  string-list "  " footer)
                   (combine string-list "  " footer)))
           list-of-string-lists))
